﻿/**
 * @fileoverview config page
 * @author sunnyjiang
 * @modified by jingleyang@tencent.com
 * @version 1.1
 * @description config 主要逻辑部分
 */
	// 加入一个重置标识位，以区分恢复及保存成功的wording
resetFlag = false;
/**
 * @function 禁止弹出右键
 */
function disable_drag() {
	$(document).bind("contextmenu", function() {return false;});
}
/**
 * @function 注册一些 div 的事件响应函数
 */
function regHandler() {
	var $thisPage = $("#thisPage");
	$("#checkupdate").click(checkupdate);
	$("#changeProxySetting").click(changeProxySetting);
	disable_drag();
	$("#defaultBrowser").click(setdefaultbrowser);
	$thisPage
		.bind('change', function() {
			$("#url-area").css("visibility", "visible");
			$("#pageLink").focus();
		})
		.bind('click', function() {
			$("#pageLink").focus();
		});
	$("#pageLink").keydown(function() {
		if (event.keyCode == 13) { // 回车
			changeRadio('homePage', $("#pageLink").val());
		}
	});
	$("#setpageLink").click(function() {
		changeRadio('homePage', $("#pageLink").val());
	});
	$("#quickLink").change(function() {
		$("#url-area").css("visibility", "hidden");
		changeRadio('homePage', 'qqbrowser:home');
	});
	$("#blank").change(function() {
		$("#url-area").css("visibility", "hidden");
		changeRadio('homePage', 'about:blank');
	});
	$("#usedefault").change(function() {
		enableDefaultDownlaodPathComboElements();
		downloadpathmodechanged();
	});
	$("#uselastpath").change(function() {
		disableDefaultDownlaodPathComboElements();
		downloadpathmodechanged();
	});
	// 设置浏览器事件的响应
	if (qqbrowser) {
		qqbrowser.extension.builtin.config.onConfigChanged.addListener(flush); // 配置有更改
		qqbrowser.account.onLogin.addListener(setLogIn);  // 用户登录成功
		qqbrowser.account.onLogout.addListener(setLogOut); // 用户注销
	}

	//标签页【新建标签页显示】模块，临时使用基本设置里的主页模块，6.14清理
	var $tabThisPage = $("#tab-thisPage");
	$tabThisPage
		.bind('change', function() {
			$("#tab-url-area").css("visibility", "visible");
			$("#tab-pageLink").focus();
		})
		.bind('click', function() {
			$("#tab-pageLink").focus();
		});
	$("#tab-pageLink").keydown(function() {
		if (event.keyCode == 13) { // 回车
			changeRadio('newPageUrl', $("#tab-pageLink").val());
		}
	});
	$("#tab-setpageLink").click(function() {
		changeRadio('newPageUrl', $("#tab-pageLink").val());
	});
	$("#tab-quickLink").change(function() {
		$("#tab-url-area").css("visibility", "hidden");
		changeRadio('newPageUrl', 'qqbrowser:home');
	});
	$("#tab-blank").change(function() {
		$("#tab-url-area").css("visibility", "hidden");
		changeRadio('newPageUrl', 'about:blank');
	});
}
/**
 * @function 用于处理下载bar 中的下载管理跳转config 页面时，设置焦点到下载项
 */
function focusHandler() {
	// 下载功能触发的初始化焦点设置，将焦点设置到下载	
	try {
		var request = ['optionFocusedType'];
		qqbrowser.extension.builtin.config.get(request, setPage);
	} catch (e) {
	}

	// 页面初始化完成后，下载导航扩展发送过来的消息，将焦点设置到下载上
	var extNavDownloadHandler = "{7EDBEBE6-565F-4aa2-93A1-AD250445A5B6}";
	try {
		qqbrowser.extension.onRequest.addListener(function(reqId, sender, request) {
			sender = JSON.parse(sender);
			request = JSON.parse(request);
			var extId = unescape(sender.extId);

			// 设置相应的下载选项
			if (extId == extNavDownloadHandler) {
				// 存取选项设置
				var optionSet = request.command;
				if (optionSet == "download") {
					try {
						var request = ['optionFocusedType'];
						qqbrowser.extension.builtin.config.get(request, setPage);
					} catch (e) {
					}
				}
			}

		});
	} catch (e) {
	}
}
/**
 * @function 基本设置页
 */
function basicHandler() {
	var leftElement = document.getElementById('general');
	leftElement.onclick = function() {
		var rightElement = document.getElementById('option-general');
		rightElement.style.display = "";
		rightElement = document.getElementById('option-tab');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-shortcutkey');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-mousegesture');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-account');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-account-none');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-advanced');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-download');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-password');
		rightElement.style.display = "none";
		rightElement = document.getElementById('mousegesture').className = "";
		rightElement = document.getElementById('tab').className = "";
		rightElement = document.getElementById('shortcutkey').className = "";
		rightElement = document.getElementById('general').className = "selected";
		rightElement = document.getElementById('account').className = "";
		rightElement = document.getElementById('advanced').className = "";
		rightElement = document.getElementById('download').className = "";
		rightElement = document.getElementById('password').className = "";

		var request = [
			'homePage',
			'searchSelect',
			'alwaysShowSystemTray',
			'minimizeToSystemTray',
			'checkDefaultBrowser',
			'favoritesDisplay',
			'qzoneDisplay',
			'screenshotDisplay',
			'clearButtonDisplay',
			'autoClean',
			'closeWndConfirm',
			'autoFill',
			'autoFillTip',
			'statusbarMute',
			'statusbarClock',
			'statusbarDict',
			'statusbarDownload',
			'statusbarTab',
			'statusbarBlock',
			'statusbarScale'
		];
		try {
			qqbrowser.extension.builtin.config.get(request, initPage1);
		} catch (err) {
			var results = "['homePage':'quickLink','searchSelect':'baidu','checkDefaultBrowser':true，'favoritesDisplay':true,'screenshotDisplay':true,'clearButtonDisplay':true,'autoClean':true,'closeWndConfirm':true, 'autoFillTip':true]";
			initPage1(results);
		}
	};
}
/**
 * @function 标签页
 */
function tabHandler() {
	var leftElement = document.getElementById('tab');
	leftElement.onclick = function() {
		var rightElement = document.getElementById('option-tab');
		rightElement.style.display = "";
		rightElement = document.getElementById('option-general');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-shortcutkey');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-mousegesture');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-account');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-account-none');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-advanced');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-download');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-password');
		rightElement.style.display = "none";
		rightElement = document.getElementById('mousegesture').className = "";
		rightElement = document.getElementById('tab').className = "selected";
		rightElement = document.getElementById('shortcutkey').className = "";
		rightElement = document.getElementById('general').className = "";
		rightElement = document.getElementById('account').className = "";
		rightElement = document.getElementById('advanced').className = "";
		rightElement = document.getElementById('download').className = "";
		rightElement = document.getElementById('password').className = "";
		var request = [
			'favoritesOpen',
			// 临时使用， 6.14删除
			'homePage',
			'newPageUrl',
			'tabWhichToActivateAfterClose',
			'addressfieldInput',
			'tabCloseManner',
			'tagPosition',
			'tagsTatus',
			'dragLink',
			'dragText',
			'dragOpenInBackgroundTab'
		];
		if (qqbrowser) {
			qqbrowser.extension.builtin.config.get(request, initPage2);
		}
	};
}
/**
 * @function 快捷键
 */
function shortcutkeyHandler() {
	var leftElement = document.getElementById('shortcutkey');
	leftElement.onclick = function() {
		/*
		 var rightElement=document.getElementById('option-shortcutkey');
		 rightElement.style.display="";
		 */
		rightElement = document.getElementById('option-tab');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-general');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-mousegesture');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-account');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-account-none');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-advanced');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-download');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-password');
		rightElement.style.display = "none";
		rightElement = document.getElementById('mousegesture').className = "";
		rightElement = document.getElementById('tab').className = "";
		rightElement = document.getElementById('shortcutkey').className = "selected";
		rightElement = document.getElementById('general').className = "";
		rightElement = document.getElementById('account').className = "";
		rightElement = document.getElementById('advanced').className = "";
		rightElement = document.getElementById('download').className = "";
		rightElement = document.getElementById('password').className = "";
		/*
		 快捷键配置
		 */
		Shortcuts.init();
	};
}
/** @function 鼠标手势 */
function mousegestureHandler() {
	var leftElement = document.getElementById('mousegesture');
	//alert(optionElement.innerHTML);
	leftElement.onclick = function() {
		//alert("OK");
		var rightElement = document.getElementById('option-mousegesture');
		rightElement.style.display = "";
		rightElement = document.getElementById('option-tab');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-shortcutkey');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-general');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-account');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-account-none');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-advanced');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-download');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-password');
		rightElement.style.display = "none";
		rightElement = document.getElementById('mousegesture').className = "selected";
		rightElement = document.getElementById('tab').className = "";
		rightElement = document.getElementById('shortcutkey').className = "";
		rightElement = document.getElementById('general').className = "";
		rightElement = document.getElementById('account').className = "";
		rightElement = document.getElementById('advanced').className = "";
		rightElement = document.getElementById('download').className = "";
		rightElement = document.getElementById('password').className = "";
		var request = ['mouseGestureOpen', 'actionTrack', 'actionTip'];
		if (qqbrowser) {
			qqbrowser.extension.builtin.config.get(request, initPage4);
		}
	};
}
function accountHandler() {
	var leftElement = document.getElementById('account');
	//alert(optionElement.innerHTML);
	leftElement.onclick = function() {
		//alert("OK");
		var rightElement = document.getElementById('option-advanced');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-tab');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-shortcutkey');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-mousegesture');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-general');
		rightElement.style.display = "none";
		qqbrowser.account.getCurrent(checkAccount);

		rightElement = document.getElementById('option-account');
		rightElement.style.display = "";
		rightElement = document.getElementById('option-account-none');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-download');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-password');
		rightElement.style.display = "none";
		rightElement = document.getElementById('mousegesture').className = "";
		rightElement = document.getElementById('tab').className = "";
		rightElement = document.getElementById('shortcutkey').className = "";
		rightElement = document.getElementById('general').className = "";
		rightElement = document.getElementById('account').className = "selected";
		rightElement = document.getElementById('advanced').className = "";
		rightElement = document.getElementById('download').className = "";
		rightElement = document.getElementById('password').className = "";
		var request = ['autoLogin', 'synchroWebpageService', 'synchroFav', 'synchroQuickLink',
			'synchroAutoSavePassword', 'synchroAutoFillForm', 'synchroCoreSwitchRule'];
		if (qqbrowser) {
			qqbrowser.extension.builtin.config.get(request, initPage5);
		}
	};
}
/** @function 高级*/
function advancedHandler() {
	var leftElement = document.getElementById('advanced');
	//alert(optionElement.innerHTML);
	leftElement.onclick = function() {
		//alert("OK");
		var rightElement = document.getElementById('option-advanced');
		rightElement.style.display = "";
		rightElement = document.getElementById('option-tab');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-shortcutkey');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-mousegesture');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-general');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-account');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-account-none');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-download');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-password');
		rightElement.style.display = "none";
		rightElement = document.getElementById('mousegesture').className = "";
		rightElement = document.getElementById('tab').className = "";
		rightElement = document.getElementById('shortcutkey').className = "";
		rightElement = document.getElementById('general').className = "";
		rightElement = document.getElementById('account').className = "";
		rightElement = document.getElementById('advanced').className = "selected";
		rightElement = document.getElementById('download').className = "";
		rightElement = document.getElementById('password').className = "";
		var request = ['ieAgent', 'browseType', 'helpTip', 'typeface', 'autoUpdate', 'safety', 'loginProtect',
			'improvePlan', 'ieRenderGPU', 'caibeiBindConfirm'];
		if (qqbrowser) {
			qqbrowser.extension.builtin.config.get(request, initPage6);
		}
	};
}
/** @function 下载 */
function downloadHandler() {
	var leftElement = document.getElementById('download');
	leftElement.onclick = function() {
		var rightElement = document.getElementById('option-download');
		rightElement.style.display = "";
		rightElement = document.getElementById('option-tab');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-shortcutkey');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-mousegesture');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-general');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-account');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-account-none');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-advanced');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-password');
		rightElement.style.display = "none";
		rightElement = document.getElementById('mousegesture').className = "";
		rightElement = document.getElementById('tab').className = "";
		rightElement = document.getElementById('shortcutkey').className = "";
		rightElement = document.getElementById('general').className = "";
		rightElement = document.getElementById('account').className = "";
		rightElement = document.getElementById('advanced').className = "";
		rightElement = document.getElementById('download').className = "selected";
		rightElement = document.getElementById('password').className = "";
		initPage7();
	};
}
/** @function 密码保存*/
function passwordHandler() {
	// 密码保存
	var leftElement = document.getElementById('password');

	leftElement.onclick = function() {

		var rightElement = document.getElementById('option-password');
		rightElement.style.display = "";
		rightElement = document.getElementById('option-download');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-tab');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-shortcutkey');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-mousegesture');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-general');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-account');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-account-none');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-advanced');
		rightElement.style.display = "none";
		rightElement = document.getElementById('mousegesture').className = "";
		rightElement = document.getElementById('tab').className = "";
		rightElement = document.getElementById('shortcutkey').className = "";
		rightElement = document.getElementById('general').className = "";
		rightElement = document.getElementById('account').className = "";
		rightElement = document.getElementById('advanced').className = "";
		rightElement = document.getElementById('download').className = "";
		rightElement = document.getElementById('password').className = "selected";

		var request = ['autoFill', 'autoFillTip'];
		try {
			qqbrowser.extension.builtin.config.get(request, initPage8);
		} catch (err) {
			results = "[ {'autoFill':true,'autoFillTip':true } ] ";
			initPage8(results);
		}
	};

	// 密码保存功能
	var rememberPWElement = document.getElementById("rememberPW");
	rememberPWElement.className = "PWSelected";

	/*
	 var neverRemindPWElement = document.getElementById("neverRemindPW");
	 neverRemindPWElement.className = "NoPWSelected";


	 // 记住密码网站事件绑定
	 rememberPWElement.onclick = function(event) {
	 if (event.currentTarget.id === "rememberPW") {
	 var savePWElement = document.getElementById("savePassword"); // 设置和密码保存相关的div
	 /*
	 savePWElement.style.display = "";
	 rememberPWElement.className = "PWSelected";
	 var neverSavePWElement = document.getElementById("neverSavePW");
	 neverSavePWElement.style.display = "none";
	 neverRemindPWElement.className = "NoPWSelected";
	 initPage8();

	 }
	 };

	 // 不再提醒网站事件绑定
	 neverRemindPWElement.onclick = function(event) {
	 if (event.currentTarget.id === "neverRemindPW") {
	 var savePWElement = document.getElementById("savePassword"); // 设置和密码保存相关的div
	 savePWElement.style.display = "none";
	 rememberPWElement.className = "NoPWSelected";
	 var neverSavePWElement = document.getElementById("neverSavePW");
	 neverSavePWElement.style.display = "";
	 neverRemindPWElement.className = "PWSelected";
	 initPage8();
	 }
	 };
	 */
}

/**
 * @function 初始化函数，页面加载完成后第一个运行
 */
function initBasic() {
	var request = [
		'homePage',
		'searchSelect',
		'alwaysShowSystemTray',
		'minimizeToSystemTray',
		'checkDefaultBrowser',
		'favoritesDisplay',
		'qzoneDisplay',
		'screenshotDisplay',
		'clearButtonDisplay',
		'autoClean',
		'closeWndConfirm',
		'autoFill',
		'autoFillTip',
		'statusbarMute',
		'statusbarClock',
		'statusbarDict',
		'statusbarDownload',
		'statusbarTab',
		'statusbarBlock',
		'statusbarScale'
	];
	try {
		qqbrowser.extension.builtin.config.get(request, initPage1);
	} catch (err) {
		results = "['homePage':'quickLink','searchSelect':'baidu','checkDefaultBrowser':true,'favoritesDisplay':true,'screenshotDisplay':true,'clearButtonDisplay':true,'autoClean':true,'closeWndConfirm':true, 'autoFillTip':true]";
		initPage1(results);
	}
}

function init() {
	// console.info("init");
	initBasic();
	// 注册一些div的事件
	regHandler();
	focusHandler();

	// 对于每个tab 单独写响应处理
	basicHandler();
	tabHandler();
	shortcutkeyHandler();
	mousegestureHandler();
	/** 账号功能暂时未开通 */
		//accountHandler();
	advancedHandler();
	downloadHandler();
	passwordHandler();
}


function setPage(results) {
	var res = eval("( " + results + " ) ");
	var optionFocused = res[0].optionFocusedType;
	if (optionFocused == "download") {
		// 显示相应的下载选项
		var rightElement = document.getElementById('option-download');
		rightElement.style.display = "";
		rightElement = document.getElementById('option-tab');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-shortcutkey');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-mousegesture');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-general');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-account');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-account-none');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-advanced');
		rightElement.style.display = "none";
		// fix bug 7070586
		rightElement = document.getElementById('option-password');
		rightElement.style.display = "none";
		rightElement = document.getElementById('mousegesture').className = "";
		rightElement = document.getElementById('tab').className = "";
		rightElement = document.getElementById('shortcutkey').className = "";
		rightElement = document.getElementById('general').className = "";
		rightElement = document.getElementById('account').className = "";
		rightElement = document.getElementById('advanced').className = "";
		rightElement = document.getElementById('download').className = "selected";
		//fix bug 7070586

		rightElement = document.getElementById('password').className = "";

		initPage7();

		// 将选项焦点设置为基本设置
		var obj = new Object();
		obj.optionFocusedType = "general";
		try {
			qqbrowser.extension.builtin.config.set(obj, function() {});
		} catch (err) {
		}
	}
}

function test() {
	var tata = document.getElementById("save-status");
	if (tata.className == "status-before") {
		tata.className = "status-middle";
	} else {
		tata.className = "status-after";
	}
}
function checkAccount(data) {
	//alert(data);
	var userInfo = eval('(' + data + ')')[0];
	//alert(userInfo.strNickName);
	if (userInfo.strNickName != '') {
		rightElement = document.getElementById('option-account');
		rightElement.style.display = "";
		rightElement = document.getElementById('option-account-none');
		rightElement.style.display = "none";
	} else {
		rightElement = document.getElementById('option-account');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-account-none');
		rightElement.style.display = "";
	}

}
function refreshdefaultbrowserinfo() {
	var a = document.getElementById("defaultBrowser").getAttribute("param");
	if ('1' == a) {
		$("#defaultBrowser").addClass("disabled");
		document.getElementById("defaultBrowserTip").innerHTML = "当前默认为QQ浏览器";
		$("#defaultBrowserTip").css("color", "hsl(210,60%,20%)");
		//	document.getElementById("defaultBrowser").setAttribute("value","恢复为IE浏览器");
	} else {
		document.getElementById("defaultBrowserTip").innerHTML = "当前默认为其他浏览器";
		document.getElementById("defaultBrowser").setAttribute("value", "设置QQ浏览器为默认");
	}
}

function changeProxySetting() {
	qqbrowser.browser.setProxy();
	qqbrowser.extension.builtin.statistics.increase(STATIS_CMD_CONFIG_PROXYSETTING_CLICKED);
}

function checkupdate() {
	var obj = {};
	obj.paramone = '1';
	obj.command = "OnManualCheckUpdate";
	try {
		qqbrowser.extension.onRequest.addListener(checkUpdateResponse);
		qqbrowser.extension.sendRequest("{3E92C4RD-2264-2g12-9BD8-7351394BAGP3}", obj,
			function(reply) {
			});
		qqbrowser.extension.builtin.statistics.increase(STATIS_CMD_CONFIG_CHECKUPDATA_CLICKED);
	} catch (err) {
		/*alert(err);*/
	}
}

var extIdAutoUpdate = "{3E92C4RD-2264-2g12-9BD8-7351394BAGP3}";
function checkUpdateResponse(reqId, sender, request) {
	try {
		sender = JSON.parse(sender);
		request = JSON.parse(request);
		var extId = unescape(sender.extId);
		if (extId != extIdAutoUpdate) {
			return;
		}

		var bEnable = request;
		if (bEnable) {
			$("#checkupdate").removeClass("disabled");
			document.getElementById("checkupdate").disabled = false;
		}
		else {
			$("#checkupdate").addClass("disabled");
			document.getElementById("checkupdate").disabled = true;
		}
	}
	catch (e) {
		//alert(e.message);
	}
}

function setdefaultbrowser() {
	var flag = document.getElementById("defaultBrowser").getAttribute("param");
	if ('0' == flag) {
		qqbrowser.browser.setDefault(true,
			function(reply) {
				var result = JSON.parse(reply)[0].result;
				document.getElementById("defaultBrowser").setAttribute("param", result);
				refreshdefaultbrowserinfo();
			}
		);
		qqbrowser.extension.builtin.statistics.increase(STATIS_CMD_CONFIG_DEFAULTQQBROWSER_CLICKED);
	}
}

function setLogIn() {
	if (document.getElementById('account').className == "selected") {
		rightElement = document.getElementById('option-account');
		rightElement.style.display = "";
		rightElement = document.getElementById('option-account-none');
		rightElement.style.display = "none";
	}
}
function setLogOut() {
	if (document.getElementById('account').className == "selected") {
		rightElement = document.getElementById('option-account');
		rightElement.style.display = "none";
		rightElement = document.getElementById('option-account-none');
		rightElement.style.display = "";
	}
}
function logIn() {
	//alert("login");
	qqbrowser.account.login();
}

function searchChange() {
	var v = document.getElementById("searchSelect").value;
	var obj = new Object();
	obj.searchSelect = v;
	try {
		qqbrowser.extension.builtin.config.set(obj, getResult);
	} catch (err) {
		getResult();
	}
}

function typefaceChange() {
	var v = document.getElementById("typeface").value;
	var obj = new Object();
	obj.typeface = v;
	try {
		qqbrowser.extension.builtin.config.set(obj, getResult);
	} catch (err) {
		getResult();
	}
}
function browsetypeChange() {
	var v = document.getElementById("browseType").value;
	if (v == 'smart') {
		document.getElementById("browseTypeTip").innerHTML = "自动为您选择最适合的浏览模式，推荐使用";
	} else if (v == 'webkit') {
		document.getElementById("browseTypeTip").innerHTML = "访问网站速度非常快，但可能对网银等网站出现不兼容问题";
	} else {
		document.getElementById("browseTypeTip").innerHTML = "对网银等只支持IE的网站，兼容性更好";
	}
	var obj = new Object();
	obj.browseType = v;
	try {
		qqbrowser.extension.builtin.config.set(obj, getResult);
	} catch (err) {
		getResult();
	}
}

function disableDownlaodPathComboElements() {
	$("#uselastpath").attr("disabled", "disabled");
	$("#usedefault").attr("disabled", "disabled");
	//$("#uselastpath").addClass("disabled");			
	//$("#usedefault").addClass("disabled");	
	$("#label_uselastpath").addClass("disabled");
	$("#label_usedefault").addClass("disabled");
	disableDefaultDownlaodPathComboElements();
	$("#option-continue-downloadtask").attr("disabled", "disabled");
	$("#label_option_continue_downloadtask").addClass("disabled");
}

function enableDownlaodPathComboElements() {
	$("#uselastpath").attr("disabled", "");
	$("#uselastpath")[0].removeAttribute("disabled");
	$("#usedefault").attr("disabled", "");
	$("#usedefault")[0].removeAttribute("disabled");
	//$("#uselastpath").removeClass("disabled");			
	//$("#usedefault").removeClass("disabled");	
	$("#label_uselastpath").removeClass("disabled");
	$("#label_usedefault").removeClass("disabled");
	if ($("#uselastpath").attr("checked")) {
		disableDefaultDownlaodPathComboElements();
	}
	else {
		enableDefaultDownlaodPathComboElements();
	}
	$("#option-continue-downloadtask").attr("disabled", "");
	$("#option-continue-downloadtask")[0].removeAttribute("disabled");
	$("#option-continue-downloadtask").removeClass("disabled");
	$("#label_option_continue_downloadtask").removeClass("disabled");
}

function disableDefaultDownlaodPathComboElements() {
	$("#defaultdownloadsavepath").attr("disabled", "disabled");
	$("#defaultdownloadsavepath").addClass("disabled");
	$("#select-download-path").addClass("disabled");
	$("#select-download-path").unbind("click");
	$("#savedefaultpath").addClass("disabled");
	$("#savedefaultpath").unbind("click");
}

function enableDefaultDownlaodPathComboElements() {
	$("#defaultdownloadsavepath").attr("disabled", "");
	$("#defaultdownloadsavepath")[0].removeAttribute("disabled");
	$("#defaultdownloadsavepath").removeClass("disabled");
	$("#select-download-path").removeClass("disabled");
	$("#select-download-path").unbind("click");
	$("#select-download-path").click(selectdownloadpath);
	$("#savedefaultpath").removeClass("disabled");
	$("#savedefaultpath").unbind("click");
	$("#savedefaultpath").click(savedownloadpath);
}

function defaultdownloadtoolsChange() {
	var v = document.getElementById("defaultdownloadtools").value;
	if ('qbdownloader' != v) {
		disableDownlaodPathComboElements();
	}
	else {
		enableDownlaodPathComboElements();
	}

	var obj = new Object();
	obj.command = 'defaultdownloadtools';
	obj.defaultdownloadtools = v;
	try {
		qqbrowser.extension.sendRequest("{7EDBEBE6-565F-4aa2-93A1-AD250445A5B6}", obj, function(reply) {});
	} catch (err) {
	}
	getResult();
}

function changeContinueDownloadTask() {
	var obj = new Object();
	obj.command = 'checkcontinuedownloadtask';
	obj.checkcontinuedownloadtask = (document.getElementById('option-continue-downloadtask').checked) ? "1" : "0";
	try {
		qqbrowser.extension.sendRequest("{7EDBEBE6-565F-4aa2-93A1-AD250445A5B6}", obj, function(reply) {});
	} catch (err) {
	}
	getResult();
}

function savedownloadpath() {
	var obj = {};
	obj.command = "defaultdownloadsavepath";
	obj.defaultdownloadsavepath = $("#defaultdownloadsavepath").val();
	try {
		qqbrowser.extension.sendRequest("{7EDBEBE6-565F-4aa2-93A1-AD250445A5B6}", obj,
			function(reply) {
				var result = eval("(" + reply + ")");
				var changefolder = unescape(result[0].changeFolder);
				if ('1' == changefolder) {
					var obj = new Object();
					obj.selectdownloadpathchangedmessage = 0;
					qqbrowser.extension.builtin.config.set(obj, getResult);
				}
				else {
					$("#defaultdownloadsavepath").focus();
				}
			}, function(reply) {}, function(reply) {}, -1);
	} catch (err) {
	}
	// getResult();
}

function resetDownload() {
	try {
		qqbrowser.extension.sendRequest('{7EDBEBE6-565F-4aa2-93A1-AD250445A5B6}', {command: 'resetdownloadconfig'}, function(jsonData) {
			initdownloadtools();
		});
	} catch (err) {
	}
}

function downloadpathmodechanged() {
	var obj = new Object();
	obj.command = "changedownloadpathmode";
	if ($("#uselastpath").attr("checked")) {
		obj.changedownloadpathmode = "uselast";
	}
	else {
		obj.changedownloadpathmode = "usedefault";
	}
	try {
		qqbrowser.extension.sendRequest("{7EDBEBE6-565F-4aa2-93A1-AD250445A5B6}", obj, function(reply) {});
	} catch (err) {
	}
	getResult();
}

function selectdownloadpath() {
	var obj = {};
	obj.command = "selectdownloadpath";
	obj.saveToPath = $("#defaultdownloadsavepath").val();
	try {
		qqbrowser.extension.sendRequest("{7EDBEBE6-565F-4aa2-93A1-AD250445A5B6}", obj,
			function(reply) {
				var result = eval("(" + reply + ")");
				var saveToPath = unescape(result[0].saveToPath);
				var changefolder = unescape(result[0].changeFolder);
				if ("" == saveToPath || '0' == changefolder) {
					return;
				}
				$("#defaultdownloadsavepath").val(saveToPath);
			}, function(reply) {}, function(reply) {}, -1);
	} catch (err) {
		getResult();
	}
}

function initdownloadtools() {
	$('#label_option_continue_downloadtask').removeClass('disabled');
	$('#option-continue-downloadtask').removeAttr('disabled').removeClass('disabled');
	
	var obj = {};
	obj.command = "querydownloadtools";
	try {
		qqbrowser.extension.sendRequest("{7EDBEBE6-565F-4aa2-93A1-AD250445A5B6}", obj,
			function(reply) {
				var result = eval("(" + reply + ")");
				var toolList = result[0].toollist;
				var pathoption = result[0].pathoption;
				var len = toolList.length;
				var sele = $("#defaultdownloadtools");
				sele.html("");
				for (var i = 0; i < len; i++) {
					if ('1' == toolList[i].selected) {
						opt = "<option selected='selected' value='" + toolList[i].toolsid + "'>" + toolList[i].toolsname + "</option>";
					} else {
						opt = "<option value='" + toolList[i].toolsid + "'>" + toolList[i].toolsname + "</option>";
					}
					sele.append(opt);
				}

				if (len == 1) {
					$("#defaultdownloadtools").css('disabled', true);
				}
				else {
					$("#defaultdownloadtools").css('disabled', false);
				}

				var v = $("#defaultdownloadtools").val();
				if ('qbdownloader' != v) {
					$("#uselastpath").attr('disabled', 'disabled');
					$("#label_uselastpath").addClass("disabled");
					$("#usedefault").attr('disabled', 'disabled');
					$("#label_usedefault").addClass("disabled");
					$("#label_option_continue_downloadtask").addClass("disabled");
					$("#option-continue-downloadtask").attr("disabled", "disabled");
					$("#option-continue-downloadtask").addClass("disabled");
					if ('uselast' == pathoption) {
						$("#uselastpath").attr("checked", "checked");
					}
					else {
						$("#usedefault").attr("checked", "checked");
					}
					disableDefaultDownlaodPathComboElements();
				}
				else {
					$("#uselastpath").attr('disabled', '');
					$("#uselastpath")[0].removeAttribute("disabled");
					$("#label_uselastpath").removeClass("disabled");
					$("#usedefault").attr('disabled', '');
					$("#usedefault")[0].removeAttribute("disabled");
					$("#label_usedefault").removeClass("disabled");

					if ('uselast' == pathoption) {
						$("#uselastpath").attr("checked", "checked");
						disableDefaultDownlaodPathComboElements();
					}
					else {
						$("#usedefault").attr("checked", "checked");
						enableDefaultDownlaodPathComboElements();
					}
				}

				var pathList = result[0].saveToPathList;
				var len = pathList.length;
				if ("" != pathList[0]) {
					$("#defaultdownloadsavepath").val(unescape(pathList[0]));
				}

				if ("1" == result[0].continuetask) {
					document.getElementById('option-continue-downloadtask').checked = true;
				}
				else {
					document.getElementById('option-continue-downloadtask').checked = false;
				}
			}, function(reply) {}, function(reply) {}, -1
		);
	} catch (err) {
	}
}

/*
 * edit by jingle 
 * 2011-02-18
 * 为了添加选项自动保存 的淡入淡出效果
 */
function changeRadio(tab, value) {
	var data = {};
	value = String(value);
	if (/^\d$/.test(value)) {
		value = Number(value);
	} else {
		value = value.trim();
		if (value === '') {
			value = 'about:blank';
		}
	}
	data[Cube.String.dashToCamel(tab)] = value;
	try {
		qqbrowser.extension.builtin.config.set(data, getResult);
	} catch (e) {
		getResult();
	}
}

function changeCheckBox(tab) {
	var obj = new Object();
	if (tab == "favoritesDisplay") {
		obj.favoritesDisplay = document.getElementById(tab).checked;
	} else if (tab == "checkDefaultBrowser") {
		obj.checkDefaultBrowser = document.getElementById(tab).checked;
	} else if (tab == "qzoneDisplay") {
		obj.qzoneDisplay = document.getElementById(tab).checked;
	} else if (tab == "screenshotDisplay") {
		obj.screenshotDisplay = document.getElementById(tab).checked;
	} else if (tab == "clearButtonDisplay") {
		obj.clearButtonDisplay = document.getElementById(tab).checked;
	} else if (tab == "favoritesOpen") {
		obj.favoritesOpen = document.getElementById(tab).checked;
	} else if (tab == "mouseGestureOpen") {
		obj.mouseGestureOpen = document.getElementById(tab).checked;
	} else if (tab == "actionTrack") {
		obj.actionTrack = document.getElementById(tab).checked;
	} else if (tab == "actionTip") {
		obj.actionTip = document.getElementById(tab).checked;
	} else if (tab == "helpTip") {
		obj.helpTip = document.getElementById(tab).checked;
	} else if (tab == "ieRenderGPU") {
		obj.ieRenderGPU = document.getElementById(tab).checked;
	} else if (tab == "autoUpdate") {
		obj.autoUpdate = document.getElementById(tab).checked;
	} else if (tab == "safety") {
		obj.safety = document.getElementById(tab).checked;
	} else if (tab == "loginProtect") {
		obj.loginProtect = document.getElementById(tab).checked;
	} else if (tab == "improvePlan") {
		obj.improvePlan = document.getElementById(tab).checked;
	} else if (tab == "alwaysShowSystemTray") {
		obj.alwaysShowSystemTray = document.getElementById(tab).checked;
	} else if (tab == "caiBei") {
		obj.caibeiBindConfirm = document.getElementById(tab).checked;
		// 加入操作过这个选项后不再打开infobar的配置项
		var cmd = {};
		cmd.caibeiOptionModified = "true";
		qqbrowser.extension.builtin.config.set(cmd, function(results) {});
	} else if (tab == "minimizeToSystemTray") {
		obj.minimizeToSystemTray = document.getElementById(tab).checked;
	} else if (tab == "autoLogin") {
		obj.autoLogin = document.getElementById(tab).checked;
	} else if (tab == "synchroWebpageService") {
		obj.synchroWebpageService = document.getElementById(tab).checked;
	} else if (tab == "synchroFav") {
		obj.synchroFav = document.getElementById(tab).checked;
	} else if (tab == "synchroQuickLink") {
		obj.synchroQuickLink = document.getElementById(tab).checked;
	} else if (tab == "synchroAutoSavePassword") {
		obj.synchroAutoSavePassword = document.getElementById(tab).checked;
	} else if (tab == "synchroAutoFillForm") {
		obj.synchroAutoFillForm = document.getElementById(tab).checked;
	} else if (tab == "synchroCoreSwitchRule") {
		obj.synchroCoreSwitchRule = document.getElementById(tab).checked;
	} else if (tab == "autoClean") {
		obj.autoClean = document.getElementById(tab).checked;
	} else if (tab == "closeWndConfirm") {
		obj.closeWndConfirm = document.getElementById(tab).checked;
	} else if (tab == "autoFill") {
		obj.autoFill = document.getElementById(tab).checked;
		if (obj.autoFill) {
			document.getElementById("autoTip").className = "autoFillTip";
			document.getElementById("autoFillTip").disabled = "";
		} else {
			document.getElementById("autoTip").className = "autoFillTipDisabled";
			document.getElementById("autoFillTip").disabled = "disabled";
		}
	} else if (tab === "autoFillTip") {
		obj.autoFillTip = document.getElementById(tab).checked;
	} else {
		obj[Cube.String.dashToCamel(tab)] = Boolean(document.getElementById(tab).checked);
	}
	try {
		qqbrowser.extension.builtin.config.set(obj, getResult);
	} catch (err) {
		getResult();
	}
}
/*
 edit by jingle
 */
function getResult(t) {
	var status = document.getElementById("save-status");
	//淡入淡出
	var val = 0.9;
	var speed = 200; // 这个控制速度 越大越慢,第一个fadein , 第二个fadeout ,可以设不同的值
	var holdontime = 800; // ms
	$(status).css("opacity", 0);
	$(status).attr('innerText', '已自动保存');
	if (resetFlag) {
		$(status).attr('innerText', '已恢复默认');
		resetFlag = false;
	}
	$(status).animate({opacity: '+=' + val}, speed, 'linear', function() {
		setTimeout(function() {
			$(status).animate({opacity: '-=' + val}, speed);
		}, holdontime);
	});

}
function resetStatus() {
	var status = document.getElementById("save-status");
	if (status.className == "status-middle") {
		status.className = "status-before";
	} else {
	}
}
function initPage1(results) {
	try {
		var res = Cube.Object.parseJson(results);
		// 根据返回值 设置主页选项 , 设置焦点
		// 6.13临时添加，6.14清理，simonsliu
		$("#url-area").css("visibility", "hidden");
		// 解决选项页面中url decode的问题
		var home = unescape(decodeURI(res[0].homePage));
		try {
			qqbrowser.log.info("home: " + home);
		} catch (err) {}

		if ("qqbrowser:home" == home) { // 默认主页
			$("#quickLink").attr('checked', true);
		} else if ("about:blank" == home) { // 空白页
			$("#blank").attr('checked', true);
		} else { // 是个网址
			$("#thisPage").attr('checked', true);
			$("#url-area").css("visibility", "visible");
			$("#pageLink").val(home);
		}

		document.getElementById("searchSelect").value = res[0].searchSelect;
		document.getElementById("checkDefaultBrowser").checked = res[0].checkDefaultBrowser;
		document.getElementById('favoritesDisplay').checked = res[0].favoritesDisplay;
		document.getElementById('qzoneDisplay').checked = res[0].qzoneDisplay;
		document.getElementById('screenshotDisplay').checked = res[0].screenshotDisplay;
		document.getElementById('clearButtonDisplay').checked = res[0].clearButtonDisplay;
		document.getElementById('alwaysShowSystemTray').checked = res[0].alwaysShowSystemTray;
		document.getElementById('minimizeToSystemTray').checked = res[0].minimizeToSystemTray;
		document.getElementById('autoClean').checked = res[0].autoClean;
		document.getElementById('closeWndConfirm').checked = res[0].closeWndConfirm;
		document.getElementById('autoFill').checked = res[0].autoFill;
		document.getElementById('autoFillTip').checked = res[0].autoFillTip;
		document.getElementById('statusbarMute').checked = res[0].statusbarMute;
		document.getElementById('statusbarClock').checked = res[0].statusbarClock;
		document.getElementById('statusbarDict').checked = res[0].statusbarDict;
		document.getElementById('statusbarDownload').checked = res[0].statusbarDownload;
		document.getElementById('statusbarTab').checked = res[0].statusbarTab;
		document.getElementById('statusbarBlock').checked = res[0].statusbarBlock;
		document.getElementById('statusbarScale').checked = res[0].statusbarScale;
		qqbrowser.browser.getDefault(function(reply) {
			var result = JSON.parse(reply)[0].result;
			document.getElementById("defaultBrowser").setAttribute("param", result);
			refreshdefaultbrowserinfo();
		});
	} catch (err) {
	}
}
function initPage2(result) {
	if (result = Cube.Object.parseJson(result)) {
		result = result[0];
	} else {
		return false;
	}
	var key, i, radioGroup, radioElement,
		radioGroups = {
			newPageUrl: document.getElementsByName('new-page-url'),
			tagPosition: document.getElementsByName('tag-position'),
			tagsTatus: document.getElementsByName('tags-tatus'),
			tabWhichToActivateAfterClose: document.getElementsByName('tab-which-to-activate-after-close'),
			tabCloseManner: document.getElementsByName('tab-close-manner'),
			addressfieldInput: document.getElementsByName('addressfield-input')
		},
		checkElements = {
			dragLink: Cube('#drag-link')[0],
			dragText: Cube('#drag-text')[0],
			dragOpenInBackgroundTab: Cube('#drag-open-in-background-tab')[0]
		};

	for (key in radioGroups) {
		radioGroup = radioGroups[key];
		for (i = 0; i < radioGroup.length; i++) {
			radioElement = radioGroup[i];
			if (Number(radioElement.value) === Number(result[key])) {
				radioElement.checked = true;
				break;
			}
		}
	}

	for (key in checkElements) {
		checkElements[key].checked = Boolean(result[key]);
	}

	// 6.13临时添加，6.14清理，simonsliu
	// 解决选项页面中url decode的问题
	$("#tab-url-area").css("visibility", "hidden");
	var newPageUrl = Cube.String.htmlDecode(result.newPageUrl);

	if (newPageUrl === 'qqbrowser:home') { // 默认主页
		$("#tab-quickLink").attr('checked', true);
	} else if (newPageUrl === 'about:blank') { // 空白页
		$("#tab-blank").attr('checked', true);
	} else { // 是个网址
		$("#tab-thisPage").attr('checked', true);
		$("#tab-url-area").css("visibility", "visible");
		$("#tab-pageLink").val(newPageUrl);
	}
}
function initPage5(results) {
	var res = eval("(" + results + ")");
	document.getElementById('autoLogin').checked = res[0].autoLogin;
	document.getElementById("synchroWebpageService").checked = res[0].synchroWebpageService;
	document.getElementById('synchroFav').checked = res[0].synchroFav;
	document.getElementById("synchroQuickLink").checked = res[0].synchroQuickLink;
	document.getElementById('synchroAutoSavePassword').checked = res[0].synchroAutoSavePassword;
	document.getElementById("synchroAutoFillForm").checked = res[0].synchroAutoFillForm;
	document.getElementById("synchroCoreSwitchRule").checked = res[0].synchroCoreSwitchRule;
}
function initPage4(results) {
	var res = eval("(" + results + ")");

	document.getElementById('mouseGestureOpen').checked = res[0].mouseGestureOpen;
	document.getElementById("actionTrack").checked = res[0].actionTrack;
	document.getElementById('actionTip').checked = res[0].actionTip;
}
function initPage6(results) {
	var res = eval("(" + results + ")");
	document.getElementById("browseType").value = res[0].browseType;
	if (res[0].browseType == 'smart') {
		document.getElementById("browseTypeTip").innerHTML = "自动为您选择最适合的浏览模式，推荐使用";
	} else if (res[0].browseType == 'webkit') {
		document.getElementById("browseTypeTip").innerHTML = "访问网站速度非常快，但可能对网银等网站出现不兼容问题";
	} else {
		document.getElementById("browseTypeTip").innerHTML = "对网银等只支持IE的网站，兼容性更好";
	}

	try {
		var ieVersion = parseInt(qqbrowser.browser.getIEVersion().substring(0, 1), 10);
		var ieRenderLabel = document.getElementById("ieRenderGPULabel");
		if (ieVersion > 8) {
			ieRenderLabel.innerHTML = '在兼容模式下开启高级渲染及GPU加速<span class="hint-text">（开启后，支持IE高级特性，但有时会存在页面不兼容的问题）'
		}
	} catch (e) {
	}

	document.getElementById('ieRenderGPU').checked = res[0].ieRenderGPU;
	document.getElementById('autoUpdate').checked = res[0].autoUpdate;
	document.getElementById('safety').checked = res[0].safety;
	document.getElementById('loginProtect').checked = res[0].loginProtect;
	document.getElementById('improvePlan').checked = res[0].improvePlan;
	document.getElementById('caiBei').checked = res[0].caibeiBindConfirm;
}

function initPage7() {

	//下载工具和路径
	try {
		initdownloadtools();
	} catch (err) {
	}
}


function initPage8(results) {
	try {
		var res = eval("( " + results + " ) ");
		document.getElementById('autoFill').checked = res[0].autoFill;
		document.getElementById('autoFillTip').checked = res[0].autoFillTip;
		if (res[0].autoFill) {
			document.getElementById("autoTip").className = "autoFillTip";
			document.getElementById("autoFillTip").disabled = "";
		} else {
			document.getElementById("autoTip").className = "autoFillTipDisabled";
			document.getElementById("autoFillTip").disabled = "disabled";
		}
	} catch (e) {

	}

	var savePWElement = document.getElementById("savePassword"); // 设置和密码保存相关的div

	// 初始化密码保存页面
	var PWdata = [];
	//	var noPwdata = [];

	// 获取已记录的列表
	var extId = "{75A78384-8765-4852-ABB7-8D5FA8BF48E2}";
	var cmdRecord = {};
	cmdRecord.command = "getRecordList";

	qqbrowser.extension.sendRequest(extId, cmdRecord, function(reply) {
		var returnObject = eval('(' + reply + ')');
		var object = unescape(returnObject[0]);
		object = unescape(object);

		var lists = eval("(" + object + ")");

		for (var i = 0; i < lists.length; i++) {
			PWdata[i] = lists[i];
		}

		if (PWdata.length === 0) {
			savePWElement.innerHTML = "目前还没有记录";
		} else {
			savePWElement.innerHTML = "";
		}

		for (var i = 0; i < PWdata.length; i++) {

			// 删除之前的记录，更新为最新
			var tempId = "websiteRecord" + (i + 1);
			var tempDiv = document.getElementById(tempId);
			if (tempDiv !== null) {
				var tempParent = tempDiv.parentNode;
				if (tempParent !== null) {
					tempParent.removeChild(tempDiv);
				}
			}

			// 初始化记录div
			var recordDiv = document.createElement("div");
			recordDiv.id = "websiteRecord" + (i + 1);
			recordDiv.className = "websitePW-record-box";

			// 初始化内容div
			var contentDiv = document.createElement("div");
			contentDiv.id = "websitePW-content";
			contentDiv.className = "websitePW-content";
			// 如果网页地址过长，截取部分显示
			var tempString;
			if (PWdata[i].length >= 50) {
				tempString = PWdata[i].slice(0, 51) + "...";
			} else {
				tempString = PWdata[i];
			}
			contentDiv.innerHTML = tempString;
			$(contentDiv).attr("dataurl", PWdata[i]);

			// 初始化删除按钮
			var deleteDiv = document.createElement("div");
			deleteDiv.id = "websitePW-delete";
			deleteDiv.className = "websitePW-delete";
			//deleteDiv.style.background = "url(images/close.png) center center no-repeat";

			// 绑定记录删除事件
			deleteDiv.onclick = function(event) {
				var parent = this.parentNode;
				var previousSibling = this.previousSibling;
				var cmdDelRecord = {};
				cmdDelRecord.command = "deleteRecordItem";
				cmdDelRecord.strUrl = $(previousSibling).attr("dataurl");
				qqbrowser.extension.sendRequest(extId, cmdDelRecord, function() {});
				if (parent !== null) {
					var grandparent = parent.parentNode;
					if (grandparent !== null) {
						grandparent.removeChild(parent);
					}
				}
			}

			// 绑定各个div至recordDiv
			recordDiv.appendChild(contentDiv);
			recordDiv.appendChild(deleteDiv);

			recordDiv.onmouseover = function(event) {
				$(this).addClass("hover");
				this.lastChild.style.background = "url(images/close.png) center center no-repeat";

			}
			recordDiv.onmouseout = function(event) {
				$(this).removeClass("hover");
				this.lastChild.style.background = null;
			}
			savePWElement.appendChild(recordDiv);
		}
	});
}

function reset() {
	if (confirm("你确定要重置选项吗?")) {
		try {
			resetFlag = true;
			//下载模块配置恢复默认
			resetDownload();
			var shortCutKey = $('#shortcutkey');
			// Modified by littleli
			// 解决当选中其他子面面恢复所有默认时，快捷键不恢复默认的问题
			if (Shortcuts && Shortcuts.Events) {
				Shortcuts.Events.on_reset();
			}
			qqbrowser.extension.builtin.config.reset(getResult);
		} catch (err) {
			getResult();
		}
	}
}
function flush(results) {
	if (rightElement = document.getElementById('general').className == "selected") {
		var request = [
			'homePage',
			'searchSelect',
			'alwaysShowSystemTray',
			'minimizeToSystemTray',
			'checkDefaultBrowser',
			'favoritesDisplay',
			'qzoneDisplay',
			'screenshotDisplay',
			'clearButtonDisplay',
			'autoClean',
			'closeWndConfirm',
			'autoFill',
			'autoFillTip',
			'statusbarMute',
			'statusbarClock',
			'statusbarDict',
			'statusbarDownload',
			'statusbarTab',
			'statusbarBlock',
			'statusbarScale'
		];
		qqbrowser.extension.builtin.config.get(request, initPage1);
	}
	else if (rightElement = document.getElementById('tab').className == "selected") {
		var request = [
			'favoritesOpen',
			// 临时使用，6.14删除
			'homePage',
			'newPageUrl',
			'tabWhichToActivateAfterClose',
			'addressfieldInput',
			'tabCloseManner',
			'tagPosition',
			'tagsTatus',
			'dragLink',
			'dragText',
			'dragOpenInBackgroundTab'
		];
		qqbrowser.extension.builtin.config.get(request, initPage2);
	}
	else if (rightElement = document.getElementById('shortcutkey').className == "selected") {
	}
	else if (rightElement = document.getElementById('mousegesture').className == "selected") {
		var request = ['mouseGestureOpen', 'actionTrack', 'actionTip'];
		qqbrowser.extension.builtin.config.get(request, initPage4);
	}
	else if (rightElement = document.getElementById('advanced').className == "selected") {
		var request = ['browseType', 'helpTip', 'typeface', 'safety', 'loginProtect', 'autoUpdate', 'improvePlan',
			'ieRenderGPU', 'alwaysShowSystemTray', 'minimizeToSystemTray', 'caibeiBindConfirm'];
		qqbrowser.extension.builtin.config.get(request, initPage6);
	}
	else if (rightElement = document.getElementById('password').className == "selected") {
		var request = ['autoFill', 'autoFillTip'];
		qqbrowser.extension.builtin.config.get(request, initPage8);
	}
}
$(function() {
	init();
});

// 弹出自动清理配置对话框
function openCleanOptionDialog() {
	var obj = {};
	obj.command = 'openCleanOptionDialog';
	obj.currentId = qqbrowser.window.currentId();
	qqbrowser.extension.sendRequest('{510EEC09-09E9-4003-AFDD-CCB3803286C3}', obj, function() {});
}

